/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExporterUtils {
    public static Tuple<Long, Long> computeRebuildTime(Plan plan, ActionActivity aa) {
        WorkplaceActivity wa;
        long totalSetupTime = 0L;
        long aaStartIncRebuild = aa.getStart();
        Iterator<WorkplaceActivity> wIt = plan.getWorkplaceSchedule(aa.getWorkplace()).backwardIterator(aa.getStart());
        while (wIt.hasNext() && !((wa = wIt.next()) instanceof ActionActivity) && !(wa instanceof CumulativeWorkplaceActivity)) {
            if (!(wa instanceof RebuildActivity)) continue;
            totalSetupTime += wa.getDuration();
            aaStartIncRebuild = wa.getStart();
        }
        return new Tuple<Long, Long>(totalSetupTime, aaStartIncRebuild);
    }

    public static List<GeneralizedOrderRequest> gorsForExport(Superplan superplan, List<GeneralizedOrderRequest> allGors, boolean fixedOnly, boolean includeVirtual) {
        ArrayList<GeneralizedOrderRequest> plannedGors = new ArrayList<GeneralizedOrderRequest>();
        for (GeneralizedOrderRequest gor : allGors) {
            if (!includeVirtual && gor.getState() == GeneralizedOrderRequest.State.VIRTUAL) continue;
            if (!fixedOnly) {
                plannedGors.add(gor);
                continue;
            }
            if (!GeneralizedOrderRequest.isDateValid(gor.getStartDate()) || gor.getStartDate() >= superplan.getFixationDate()) continue;
            plannedGors.add(gor);
        }
        return plannedGors;
    }
}

